﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using System.Text;

namespace AspNetMember
{
    public partial class frmUpdateProfile : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            //*** Check login Status ***'
            if (Convert.ToString(Session["strUsername"]) == "")
            {
                Response.Redirect("frmLogin.aspx");
                Response.End();
            }

            this.pnlProfile.Visible = true;
            this.pnlFinish.Visible = false;

            if (!Page.IsPostBack)
            {
                ShowDataInfo();
            }
        }

        protected void ShowDataInfo()
        {
            SqlConnection objConn = null;
            string strConnString = null;
            StringBuilder strSQL = default(StringBuilder);
            SqlCommand objCmd = null;
            SqlDataReader dtReader = null;


            //*** Open Connection ***'
            strConnString = "Server=localhost;UID=sa;PASSWORD=;database=mydatabase;Max Pool Size=400;Connect Timeout=600;";
            objConn = new SqlConnection();
            objConn.ConnectionString = strConnString;
            objConn.Open();

            //*** Get Data ***'
            strSQL = new StringBuilder();
            strSQL.Append(" SELECT * FROM member ");
            strSQL.Append(" WHERE Username = @sUsername ");
            objCmd = new SqlCommand(strSQL.ToString(), objConn);
            objCmd.Parameters.Add("@sUsername", SqlDbType.VarChar).Value = Session["strUsername"];
            dtReader = objCmd.ExecuteReader();

            if (dtReader.HasRows)
            {
                dtReader.Read();
                this.lblUsername.Text = dtReader["Username"].ToString();
                this.txtName.Text = dtReader["Name"].ToString();
                this.txtEmail.Text = dtReader["Email"].ToString();
                this.txtCountry.Text = dtReader["Country"].ToString();
            }

            dtReader.Close();
            objConn.Close();
            objConn = null;

        }

        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            SqlConnection objConn = null;
            string strConnString = null;
            StringBuilder strSQL = default(StringBuilder);
            SqlCommand objCmd = null;
            int intCount = 0;

            //*** Open Connection ***//
            strConnString = "Server=localhost;UID=sa;PASSWORD=;database=mydatabase;Max Pool Size=400;Connect Timeout=600;";
            objConn = new SqlConnection();
            objConn.ConnectionString = strConnString;
            objConn.Open();

            //*** Check Email exists ***//
            strSQL = new StringBuilder();
            strSQL.Append(" SELECT COUNT(*) FROM member ");
            strSQL.Append(" WHERE Email = @sEmail AND Username <> @sUsername");
            objCmd = new SqlCommand(strSQL.ToString(), objConn);
            objCmd.Parameters.Add("@sEmail", SqlDbType.VarChar).Value = this.txtEmail.Text;
            objCmd.Parameters.Add("@sUsername", SqlDbType.VarChar).Value = Session["strUsername"];
            intCount = (int)objCmd.ExecuteScalar();
            if (intCount >= 1)
            {
                this.lblStatus.ForeColor = System.Drawing.Color.Red;
                this.lblStatus.Text = "Email already exists!!";
                return;
            }

            //'*** Update Profile ***//
            strSQL = new StringBuilder();
            strSQL.Append(" UPDATE member ");
            strSQL.Append(" SET Password = @sPassword ");
            strSQL.Append(" ,Name = @sName ");
            strSQL.Append(" ,Email = @sEmail ");
            strSQL.Append(" ,Country = @sCountry ");
            strSQL.Append(" WHERE Username = @sUsername");
            objCmd = new SqlCommand(strSQL.ToString(), objConn);
            objCmd.Parameters.Add("@sPassword", SqlDbType.VarChar).Value = this.txtPassword.Text;
            objCmd.Parameters.Add("@sName", SqlDbType.VarChar).Value = this.txtName.Text;
            objCmd.Parameters.Add("@sEmail", SqlDbType.VarChar).Value = this.txtEmail.Text;
            objCmd.Parameters.Add("@sCountry", SqlDbType.VarChar).Value = this.txtCountry.Text;
            objCmd.Parameters.Add("@sUsername", SqlDbType.VarChar).Value = Session["strUsername"];
            objCmd.ExecuteNonQuery();

            objConn.Close();
            objConn = null;

            this.pnlProfile.Visible = false;
            this.pnlFinish.Visible = true;
        }
    }
}