﻿Imports System.Data
Imports System.Data.SqlClient

Partial Public Class frmUpdateProfile
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        '*** Check login Status ***'
        If Session("strUsername") = "" Then
            Response.Redirect("frmLogin.aspx")
            Response.End()
        End If

        Me.pnlProfile.Visible = True
        Me.pnlFinish.Visible = False

        If Not Page.IsPostBack() Then
            ShowDataInfo()
        End If

    End Sub

    Protected Sub ShowDataInfo()

        Dim objConn As SqlConnection
        Dim strConnString As String
        Dim strSQL As StringBuilder
        Dim objCmd As SqlCommand
        Dim dtReader As SqlDataReader


        '*** Open Connection ***'
        strConnString = "Server=localhost;UID=sa;PASSWORD=;database=mydatabase;Max Pool Size=400;Connect Timeout=600;"
        objConn = New SqlConnection
        objConn.ConnectionString = strConnString
        objConn.Open()

        '*** Get Data ***'
        strSQL = New StringBuilder
        strSQL.Append(" SELECT * FROM member ")
        strSQL.Append(" WHERE Username = @sUsername ")
        objCmd = New SqlCommand(strSQL.ToString(), objConn)
        objCmd.Parameters.Add("@sUsername", SqlDbType.VarChar).Value = Session("strUsername")
        dtReader = objCmd.ExecuteReader()

        If dtReader.HasRows Then
            dtReader.Read()
            Me.lblUsername.Text = dtReader("Username").ToString()
            Me.txtName.Text = dtReader("Name").ToString()
            Me.txtEmail.Text = dtReader("Email").ToString()
            Me.txtCountry.Text = dtReader("Country").ToString()
        End If

        dtReader.Close()
        objConn.Close()
        objConn = Nothing

    End Sub

    Protected Sub btnUpdate_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnUpdate.Click

        Dim objConn As SqlConnection
        Dim strConnString As String
        Dim strSQL As StringBuilder
        Dim objCmd As SqlCommand
        Dim intCount As Integer = 0

        '*** Open Connection ***'
        strConnString = "Server=localhost;UID=sa;PASSWORD=;database=mydatabase;Max Pool Size=400;Connect Timeout=600;"
        objConn = New SqlConnection
        objConn.ConnectionString = strConnString
        objConn.Open()

        '*** Check Email exists ***'
        strSQL = New StringBuilder
        strSQL.Append(" SELECT COUNT(*) FROM member ")
        strSQL.Append(" WHERE Email = @sEmail AND Username <> @sUsername")
        objCmd = New SqlCommand(strSQL.ToString(), objConn)
        objCmd.Parameters.Add("@sEmail", SqlDbType.VarChar).Value = Me.txtEmail.Text
        objCmd.Parameters.Add("@sUsername", SqlDbType.VarChar).Value = Session("strUsername")
        intCount = objCmd.ExecuteScalar()
        If intCount >= 1 Then
            Me.lblStatus.ForeColor = Drawing.Color.Red
            Me.lblStatus.Text = "Email already exists!!"
            Exit Sub
        End If

        ''*** Update Profile ***'
        strSQL = New StringBuilder
        strSQL.Append(" UPDATE member ")
        strSQL.Append(" SET Password = @sPassword ")
        strSQL.Append(" ,Name = @sName ")
        strSQL.Append(" ,Email = @sEmail ")
        strSQL.Append(" ,Country = @sCountry ")
        strSQL.Append(" WHERE Username = @sUsername")
        objCmd = New SqlCommand(strSQL.ToString(), objConn)
        objCmd.Parameters.Add("@sPassword", SqlDbType.VarChar).Value = Me.txtPassword.Text
        objCmd.Parameters.Add("@sName", SqlDbType.VarChar).Value = Me.txtName.Text
        objCmd.Parameters.Add("@sEmail", SqlDbType.VarChar).Value = Me.txtEmail.Text
        objCmd.Parameters.Add("@sCountry", SqlDbType.VarChar).Value = Me.txtCountry.Text
        objCmd.Parameters.Add("@sUsername", SqlDbType.VarChar).Value = Session("strUsername")
        objCmd.ExecuteNonQuery()

        objConn.Close()
        objConn = Nothing

        Me.pnlProfile.Visible = False
        Me.pnlFinish.Visible = True

    End Sub

End Class